#include "utils.h"
#include <iomanip>

void printIPAddress(u_int addr)
{
	cout << ((addr >> 24) & 0xff) << "."
       << ((addr >> 16) & 0xff) << "." 
       << ((addr >> 8) & 0xff) << "." 
       << (addr & 0xff); 
}

void printIPAddress(const u_char *addr)
{
  cout << (int) addr[0];
  for (int i = 1; i < IP_ALEN; i++) {
    cout << "." << (int) addr[i];
  }
}

void printMACAddress(const u_char *addr)
{
  cout << setbase(16) << setfill('0') << setw(2) << (int) addr[0];
  for (int i = 1; i < ETH_ALEN; i++) {
    cout << ":" << setw(2) << (int) addr[i];
  }
  cout << setfill(' ') << setbase(10);
}


u_int IP_ch2int(const u_char *address)
{
    return (address[0] << 24) + (address[1] << 16) + (address[2] << 8) + address[3];
}

u_int IP_str2int(const char *address)
{
	int ip[IP_ALEN];
	u_char ipch[IP_ALEN];

	sscanf(address,"%d.%d.%d.%d",&ip[0],&ip[1],&ip[2],&ip[3]);

	for(int i=0; i < IP_ALEN; i++)
		ipch[i] = (u_char) ip[i];
	
	return IP_ch2int(ipch);
}

void IP_str2ch(const char *address, u_char ipch[IP_ALEN])
{
	int ip[IP_ALEN];

	sscanf(address,"%d.%d.%d.%d",&ip[0],&ip[1],&ip[2],&ip[3]);

	for(int i=0; i < IP_ALEN; i++)
		ipch[i] = (u_char) ip[i];
}


bool Compare(const u_char *val1, const u_char *val2, u_char length)
{
    for (int i = 0; i < length; i++)
        if (val1[i] != val2[i])
            return false;
    return true;
}


